--ResetMesh 0.3
--by alphaZomega

fn getNumUVChannels meshIn = (
	count = 0
	for i in 1 to meshOp.getNumMaps meshIn do (
		if meshOp.getMapSupport meshIn i then
			count += 1
	)
	return count
)
/*
fn enableSuppressDialog = 
(
	DialogMonitorOPS.unRegisterNotification id:#resetWatcher

	local enabled = DialogMonitorOPS.enabled
	fn notification act:enabled = 
	(
		hwnd = DialogMonitorOPS.GetWindowHandle()
		if (UIAccessor.isWindow hwnd) and (UIAccessor.GetWindowText hwnd) == "Unwrap UVW" do
		(
			UIAccessor.PressButtonByName hwnd "&Yes"
		)
		DialogMonitorOPS.unRegisterNotification id:#resetWatcher
	)
	enabled = DialogMonitorOPS.enabled
	DialogMonitorOPS.RegisterNotification notification id:#resetWatcher
	DialogMonitorOPS.enabled = on
)
*/
fn doReset meshIn cloneUVs skipGpoly = 
(
	numUVChannels = getNumUVChannels(meshIn)
	addModifier meshIn (Unwrap_UVW())
	unwrapMod = meshIn.modifiers["Unwrap_UVW"]
	unwrapMod.setWeldThreshold 0.00001
	numVerts = unwrapMod.numberVerticesByNode meshIn
	unwrapMod.selectVerticesByNode #{1..numVerts} meshIn
	unwrapMod.weldSelected()
	
	
	-- Move UV1 to Vertex Color, UV2 to UV1 for welding, then move UV2 back and UV1 back
	if cloneUVs == false then (
		ChannelInfo.CopyChannel $ 3 1
		ChannelInfo.PasteChannel $ 3 0
		ChannelInfo.CopyChannel $ 3 2
		ChannelInfo.PasteChannel $ 3 1
		addModifier meshIn (Unwrap_UVW())
		unwrapMod2 = meshIn.modifiers["Unwrap_UVW"]
		unwrapMod2.setWeldThreshold 0.00001
		numVerts = unwrapMod2.numberVerticesByNode meshIn
		unwrapMod2.selectVerticesByNode #{1..numVerts} meshIn
		unwrapMod2.weldSelected()
		unwrapMod2.setMapChannel 2
		ChannelInfo.CopyChannel $ 3 0
		ChannelInfo.PasteChannel $ 3 1
		ChannelInfo.ClearChannel $ 0
	) else (
		addModifier meshIn (Unwrap_UVW())
		meshIn.modifiers["Unwrap_UVW"].setMapChannel 2
	)
	
	-- Turn to gPoly and correct gPoly UV shift
	if skipGpoly == false do 
		addModifier meshIn (TurnToGpoly())
	convertToMesh meshIn
	addModifier meshIn (UVW_Xform())
	xformMod = meshIn.modifiers["UVW_Xform"]	
	xformMod.V_Offset = -1.0
	update meshIn
	if cloneUVs == false then (
		addModifier $ (UVW_Xform())
		xformMod2 = $.modifiers["UVW_Xform"]
		xformMod2.Map_Channel = 2
		xformMod2.V_Offset = -1.0
	) else (
		ChannelInfo.CopyChannel $ 3 1
		ChannelInfo.PasteChannel $ 3 2
	)
	CollapseStack meshIn
	meshIn
)


rollout ResetMesh "ResetMesh 0.3" 
(
	local numIterations = 2
	button BtnResetMesh "ResetMesh"
		toolTip:"Collapses the stack and resets a Submesh for export"
	edittext FldIterations "Max Welding Iterations:" text:"2" fieldWidth:15 labelOnTop:false
		toolTip:"Maximum number of times the script will repeat the welding process"
	checkbox BtnClone "Reset as duplicate" checked:true
		toolTip:"Clones the selected mesh and resets the clone"
	checkbox BtnWeld "Weld overlapping vertices" checked:true
		toolTip:"Welds duplicated vertices together"
	checkbox BtnCloneChannel "Copy UV1 over UV2" checked:true
		tooltip:"Copy UV Channel 1 over UV Channel 2"
	checkbox BtnRemoveMaterials "Remove Materials"
		toolTip:"Removes texture materials from the mesh"
	checkbox BtnAvgNormals "Smooth Normals"
		toolTip:"Average normals to 0.001 threshold"
	checkbox BtnSkinWrap "Transfer Skin"
		toolTip:"Skins the cloned mesh to the original mesh"

	label lbl2 "By alphaZomega" align:#right
	
	on FldIterations entered num do (
		numIterations = num as integer
	)
	
	on BtnResetMesh pressed do (
		if selection.count == 1 then (
		
			cloneUVs = true
			if (BtnCloneChannel.state == false and getNumUVChannels($)  != 1) do
				cloneUVs = false
			
			skipGpoly = false
			if numIterations < 0 do
				skipGpoly = true
				
			max modify mode
			with redraw off (
				origNode = $
				
				-- Clone Mesh
				if BtnClone.state == true do (
					copyNodes = #()
					maxOps.cloneNodes selection cloneType:#copy newNodes:&copyNodes #nodialog
					select copyNodes[1]
				)
				
				-- Remove Materials
				if BtnRemoveMaterials.state == true do 
					$.material = undefined
				
				CollapseStack $
				
				vertsTest = 0
				for i=1 to abs numIterations do (
					
					-- Exit loop if num verts is not changing down
					if vertsTest == getNumVerts $ then (
						EXIT
					) else (
						vertsTest = getNumVerts $
						-- Weld Overlapping Verts
						if BtnWeld.state == true do 
							meshop.weldVertsByThreshold $ $.mesh.verts 0.0001 
						
						-- Weld overlapping UV verts and Turn to gPoly, then turn back to Mesh
						doReset $ cloneUVs skipGpoly
					)
				)
				ChannelInfo.update()
				
				-- Average Normals
				if BtnAvgNormals.state == true then (
					addModifier $ (Edit_Normals())
					myNorm = $.modifiers["Edit Normals"]
					myNorm.EditNormalsMod.SetSelection #{1..myNorm.GetNumNormals()}
					myNorm.Average useThresh:true threshold:0.001	
				)
			)
			
			-- Transfer Skin
			if (BtnSkinWrap.state == true and BtnClone.state == true and origNode.modifiers["Skin"] != undefined) do (
				max modify mode
				skinUtils.ExtractSkinData origNode
				objID = amax (for o in objects collect o.inode.handle) 
				skinData = (maxOps.getNodeByHandle objID)
				print skinData.name
				addModifier $ (Skin_Wrap())
				skinWrap = $.modifiers["Skin_Wrap"]
				skinWrap.weightAllVerts = true
				oldDistance = skinWrap.Distance
				skinWrap.Distance = 0.05
				skinWrap.meshList = #(origNode)
				skinWrap.convertToSkin false
				skinUtils.ImportSkinDataNoDialog true false false false false 0.01 0
				mySkin = $.modifiers["Skin"]
				mySkin.bone_Limit = 8
				mySkin.clearZeroLimit = 0.000
				skinOps.RemoveZeroWeights mySkin
				skinWrap.Distance = oldDistance
				deleteModifier $ skinWrap
				delete skinData
			)
			
			-- Rename to Original
			$.name = origNode.name
			Gc()
			
			endString = "Selected mesh has been reset."
			messageBox endString
		) else (
			failString = "Must select one (1) submesh."
			messageBox failString
		)
	)
)
createDialog ResetMesh 160 190